
// baslerCam2013Dlg.cpp :  
//

#include "stdafx.h"
#include "baslerCam2013.h"
#include "baslerCam2013Dlg.h"
#include "afxdialogex.h"

//#pragma (disable:4996)

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// 带 ϱ   Լ
BOOL m_bThreadFlag;							//   
UINT ThreadImageCaptureFunc(LPVOID param);	//  Լ
IplImage* m_Image;							// ȭ鿡 ׸  ̹
CInstantCamera *m_pCamera;					// Basler Camera
CGrabResultPtr ptrGrabResult;				// This smart pointer will receive the grab result data.


// Number of images to be grabbed.
static const uint32_t c_countOfImagesToGrab = 100;


//CInstantCamera *m_pCamera;

//  α׷  Ǵ CAboutDlg ȭ Դϴ.

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// ȭ  Դϴ.
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV Դϴ.

// Դϴ.
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CbaslerCam2013Dlg ȭ 



CbaslerCam2013Dlg::CbaslerCam2013Dlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CbaslerCam2013Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pCamera = NULL;
}

void CbaslerCam2013Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_VIEW, m_View);
	DDX_Control(pDX, IDC_VIEW_BIN, m_ViewBin);
}

BEGIN_MESSAGE_MAP(CbaslerCam2013Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CAM_START, &CbaslerCam2013Dlg::OnBnClickedCamStart)
	ON_BN_CLICKED(IDC_CAM_STOP, &CbaslerCam2013Dlg::OnBnClickedCamStop)
	ON_BN_CLICKED(IDC_BMP_LOAD, &CbaslerCam2013Dlg::OnBnClickedBmpLoad)
	ON_BN_CLICKED(IDC_BMP_SAVE, &CbaslerCam2013Dlg::OnBnClickedBmpSave)
	ON_WM_TIMER()
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// CbaslerCam2013Dlg ޽ ó

BOOL CbaslerCam2013Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// ý ޴ "..." ޴ ׸ ߰մϴ.

	// IDM_ABOUTBOX ý   ־ մϴ.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	//  ȭ   մϴ.   α׷  â ȭ ڰ ƴ 쿡
	//  ӿũ  ۾ ڵ մϴ.
	SetIcon(m_hIcon, TRUE);			// ū  մϴ.
	SetIcon(m_hIcon, FALSE);		//   մϴ.

	// TODO: ⿡ ߰ ʱȭ ۾ ߰մϴ.
	
	// Before using any pylon methods, the pylon runtime must be initialized. 
	PylonInitialize();

	// Automagically call PylonInitialize and PylonTerminate to ensure the pylon runtime system
	// is initialized during the lifetime of this object.
	//Pylon::PylonAutoInitTerm autoInitTerm;

	// Get the transport layer factory.
	CTlFactory& tlFactory = CTlFactory::GetInstance();

	// Get all attached devices and exit application if no device is found.
	DeviceInfoList_t devices;
	if (tlFactory.EnumerateDevices(devices) == 0)
	{
		MessageBox(L"Basler Camera  ʾҽϴ.");
	}
	else {
		// create device
		//IPylonDevice *pDevice = TlFactory.CreateDevice(lstDevices[0]);

		// Create an instant camera object with the camera device found first.
		m_pCamera = new CInstantCamera(CTlFactory::GetInstance().CreateFirstDevice());



		// Print the model name of the m_pCamera->
		cout << "Using device " << m_pCamera->GetDeviceInfo().GetModelName() << endl;

		// The parameter MaxNumBuffer can be used to control the count of buffers
		// allocated for grabbing. The default value of this parameter is 10.
		m_pCamera->MaxNumBuffer = 5;


		INodeMap& nodemap = m_pCamera->GetNodeMap();

		// Open the camera for accessing the parameters.
		m_pCamera->Open();

		// Get the integer nodes describing the AOI.
		CIntegerPtr offsetX(nodemap.GetNode("OffsetX"));
		CIntegerPtr offsetY(nodemap.GetNode("OffsetY"));
		CIntegerPtr width(nodemap.GetNode("Width"));
		CIntegerPtr height(nodemap.GetNode("Height"));

		// On some cameras the offsets are read-only,
		// so we check whether we can write a value. Otherwise, we would get an exception.
		// GenApi has some convenience predicates to check this easily.
		if (IsWritable(offsetX))
		{
			offsetX->SetValue(640 / 2);
		}
		if (IsWritable(offsetY))
		{
			offsetY->SetValue(480 / 2);
		}


		// Close the m_pCamera->
		m_pCamera->Close();

		//m_pCamera->StartGrabbing( /*c_countOfImagesToGrab*/);

		//Pylon::DisplayImage(1, ptrGrabResult);
	}

	return TRUE;  // Ŀ Ʈѿ   TRUE ȯմϴ.
}

void CbaslerCam2013Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// ȭ ڿ ּȭ ߸ ߰   ׸
//  Ʒ ڵ尡 ʿմϴ.  /  ϴ MFC  α׷ 쿡
//  ӿũ  ۾ ڵ մϴ.

void CbaslerCam2013Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // ׸⸦  ̽ ؽƮԴϴ.

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Ŭ̾Ʈ 簢   ϴ.
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  ׸ϴ.
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();


		if (m_Image != NULL) {

			// ---------------------------------------------------------------
			// ī޶󿡼 о  ȭ鿡 ׸
			// ---------------------------------------------------------------
			CRect rect;
			CDC* pDC;
			pDC = m_View.GetDC();
			m_View.GetClientRect(rect);

			m_cImage.CopyOf(m_Image);
			m_cImage.DrawToHDC(pDC->m_hDC, rect);

			ReleaseDC(pDC);

			// ---------------------------------------------------------------------
			//  ҽ   ͸ ٷ  .
			// opencv imageData Ϸ (unsigned char) ȯ Ѵ.
			// ---------------------------------------------------------------------

			// Į󿵻 ȭ Ѵ.
			pDC = m_ViewBin.GetDC();
			m_ViewBin.GetClientRect(rect);


			for (int y = 0; y < m_Image->height; y++) {
				for (int x = 0; x < m_Image->widthStep; x++) {
					if ( (unsigned char) m_Image->imageData[y*m_Image->widthStep + x] > 100)
						m_Image->imageData[y*m_Image->widthStep + x] = 255;
					else
						m_Image->imageData[y*m_Image->widthStep + x] = 0;
				}
			}

			m_cImage.CopyOf(m_Image);
			m_cImage.DrawToHDC(pDC->m_hDC, rect);

			ReleaseDC(pDC);
			// ---------------------------------------------------------------

		}
	}
}

// ڰ ּȭ â  ȿ Ŀ ǥõǵ ýۿ
//   Լ ȣմϴ.
HCURSOR CbaslerCam2013Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CbaslerCam2013Dlg::OnBnClickedCamStart()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	if (m_pCamera == NULL) {
		MessageBox(L"Basler Camera   ٽ ּ.");
		return;
	}

	m_pCamera->StartGrabbing( /*c_countOfImagesToGrab*/);

	m_bThreadFlag = TRUE;
	CWinThread *pThread = ::AfxBeginThread(ThreadImageCaptureFunc, this);
}


void CbaslerCam2013Dlg::OnBnClickedCamStop()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	if (m_pCamera == NULL) {
		MessageBox(L"Basler Camera   ٽ ּ.");
		return;
	}

	m_pCamera->StopGrabbing();

	m_bThreadFlag = FALSE;
}


void CbaslerCam2013Dlg::OnBnClickedBmpLoad()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.

	wchar_t szFilter[] = _T("Image (*.BMP) | *.BMP;*.GIF;*.JPG | All Files(*.*)|*.*||");
	CFileDialog dlg(TRUE, _T("bmp"), _T("test"), OFN_HIDEREADONLY, szFilter);
	if (dlg.DoModal() == IDOK)
	{
		CRect rect;
		//m_View.GetWindowRect(&rect);
		//LoadBMPIntoDC2(::GetDC(m_View.GetSafeHwnd()), dlg.GetPathName().GetBuffer(0), rect.Width(), rect.Height());
		CStringA filename(dlg.GetPathName());
		m_Image = cvLoadImage(filename);
		Invalidate(FALSE);
	}
}


void CbaslerCam2013Dlg::OnBnClickedBmpSave()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.

	wchar_t szFilter[] = _T("Image (*.BMP) | *.BMP;*.GIF;*.JPG | All Files(*.*)|*.*||");
	CFileDialog dlg(FALSE, _T("bmp"), _T("test"), OFN_HIDEREADONLY, szFilter);
	if (dlg.DoModal() == IDOK)
	{
		cvFlip(m_Image, m_Image, 0); // vertical
		CStringA filename(dlg.GetPathName());
		cvSaveImage(filename, m_Image);
		//SaveBMP2((BYTE*)ptrGrabResult->GetBuffer(), m_Image->width, m_Image->height,
		//	m_Image->imageSize, dlg.GetPathName().GetBuffer(0), 8);
	}
}


void CbaslerCam2013Dlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: ⿡ ޽ ó ڵ带 ߰ /Ǵ ⺻ ȣմϴ.
	//KillTimer(1);


	CDialogEx::OnTimer(nIDEvent);

	
}


void CbaslerCam2013Dlg::OnDestroy()
{
	CDialogEx::OnDestroy();

	// TODO: ⿡ ޽ ó ڵ带 ߰մϴ.
	// Releases all pylon resources. 
	PylonTerminate();

	m_pCamera->StopGrabbing();
	m_bThreadFlag = FALSE;

	if (m_pCamera != NULL) delete m_pCamera;
}


UINT ThreadImageCaptureFunc(LPVOID param)
{
	CbaslerCam2013Dlg *pDlg = (CbaslerCam2013Dlg *)param;

	if (m_pCamera == NULL) return 0;

	while (m_bThreadFlag)
	{
		// m_pCamera->StopGrabbing() is called automatically by the RetrieveResult() method
		// when c_countOfImagesToGrab images have been retrieved.
		try
		{

			if (m_pCamera->IsGrabbing())
			{
				// Wait for an image and then retrieve it. A timeout of 5000 ms is used.
				m_pCamera->RetrieveResult(5000, ptrGrabResult, TimeoutHandling_ThrowException);

				// Image grabbed successfully?
				if (ptrGrabResult->GrabSucceeded())
				{
					// Access the image data.
					cout << "SizeX: " << ptrGrabResult->GetWidth() << endl;
					cout << "SizeY: " << ptrGrabResult->GetHeight() << endl;
					const uint8_t *pImageBuffer = (uint8_t *)ptrGrabResult->GetBuffer();
					cout << "Gray value of first pixel: " << (uint32_t)pImageBuffer[0] << endl << endl;

#ifdef PYLON_WIN_BUILD
					// Display the grabbed image.
					//Pylon::DisplayImage(1, ptrGrabResult);
#endif

					if (m_Image == NULL) {
						m_Image = cvCreateImage(
							cvSize(ptrGrabResult->GetWidth(), ptrGrabResult->GetHeight()),
							IPL_DEPTH_8U, 1);
					}
					memcpy(m_Image->imageData, pImageBuffer,
						ptrGrabResult->GetWidth() * ptrGrabResult->GetHeight());

					pDlg->Invalidate(FALSE);
				}
				else
				{
					cout << "Error: " << ptrGrabResult->GetErrorCode() << " " << ptrGrabResult->GetErrorDescription() << endl;
				}
								
			}

		}
		catch (GenICam::GenericException &e)
		{
			// Error handling.
			cerr << "An exception occurred." << endl
				<< e.GetDescription() << endl;
		}

	}

	return 0;
}
