﻿
// baslerCam2023Dlg.h: 헤더 파일
//

#pragma once

#include <opencv2/opencv.hpp>
#include <pylon/PylonIncludes.h>

using namespace Pylon;
using namespace GenApi;
using namespace cv;


UINT ThreadImageCaptureFunc(LPVOID param);  // 쓰레드 함수
void FillBitmapInfo(BITMAPINFO* bmi, int width, int height, int bpp, int origin);
void DisplayImage(CDC* pDC, CRect rect, Mat& srcimg);

// CbaslerCam2023Dlg 대화 상자
class CbaslerCam2023Dlg : public CDialogEx
{
// 생성입니다.
public:
	CbaslerCam2023Dlg(CWnd* pParent = nullptr);	// 표준 생성자입니다.

// 대화 상자 데이터입니다.
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_BASLERCAM2023_DIALOG };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV 지원입니다.

public:
	BOOL m_bThreadFlag;                 // 쓰레드 루프 돌기
	CInstantCamera* m_pCamera;          // Basler Camera
	CGrabResultPtr m_ptrGrabResult;     // grab result data 받기
	Mat m_Image;

// 구현입니다.
protected:
	HICON m_hIcon;

	// 생성된 메시지 맵 함수
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedCamStart();
	afx_msg void OnBnClickedCamStop();
	CStatic m_CamView;
	afx_msg void OnDestroy();
};
