// C++ implementation of Plane Homography
// Using ezMTL C++ library for handling matrices
// Made by DJKang, 2008 PNU
#include <stdio.h>

#include "./ezmtl/Matrix.h"
// _x1   ǥ
// _x2   ǥ
// _x2 = H*_x1 

void main()
{
	Matrix<double> A(10,8), x1(5,2), x2(5,2), b(10,1);
	int i;
	//  ǥ
	x1(1,1) =   0;  x1(1,2)  =   0;
	x1(2,1) = 140;  x1(2,2)  =   0;
	x1(3,1) = 140;  x1(3,2)  =  90;
	x1(4,1) =   0;  x1(4,2)  =  90;
	//  ǥ
	x2(1,1) = 295.6825;  x2(1,2)  =   24.6023;
	x2(2,1) =  49.2821;  x2(2,2)  =  303.4359;
	x2(3,1) =  87.9020;  x2(3,2)  =  574.4706;
	x2(4,1) = 424.3918;  x2(4,2)  =  465.4169;

	// A   b 
	for(i=0; i<4; i++)
	{
		A(2*i+1,3) = 1.0;
		A(2*i+1,4) = A(2*i+1,5) = A(2*i+1,6) = 0.0;
		A(2*i+2,1) = A(2*i+2,2) = A(2*i+2,3) = 0.0;
		A(2*i+2,6) = 1.0;
	}

	for(i=0; i<4; i++)
	{
		A(2*i+1,1) =  x1(i+1,1);
		A(2*i+1,2) =  x1(i+1,2);
		A(2*i+1,7) = -x2(i+1,1)*x1(i+1,1);
		A(2*i+1,8) = -x2(i+1,1)*x1(i+1,2);

		A(2*i+2,4) =  x1(i+1,1);
		A(2*i+2,5) =  x1(i+1,2);
		A(2*i+2,7) = -x2(i+1,2)*x1(i+1,1);
		A(2*i+2,8) = -x2(i+1,2)*x1(i+1,2);

		b(2*i+1,1) =  x2(i+1,1);
		b(2*i+2,1) =  x2(i+1,2);
	}
 	A.Print(cout,"A =");

	// Ax=b ϱ
	int retCode;
	Matrix<double> x(8,1);
	// pseudo inverse,  x = (AT * T)^-1 * AT * b
	x = Inv(Transpose(A) * A, &retCode) * Transpose(A) * b;
	x.Print(cout,"x =");

	// H = x
	Matrix<double> hh(3,3), w(3,1), c(3,1);
	hh(1,1) = x(1,1); hh(1,2) = x(2,1); hh(1,3) = x(3,1);
	hh(2,1) = x(4,1); hh(2,2) = x(5,1); hh(2,3) = x(6,1);
	hh(3,1) = x(7,1); hh(3,2) = x(8,1); hh(3,3) = 1.0;
	hh.Print(cout, "H =");

	// ǥ x1 ־  ȯ ǥ x3  
	for(i=0; i<4; i++)
	{
		 w(1,1) = x1(i+1,1);
		 w(2,1) = x1(i+1,2);
		 w(3,1) = 1.0;

		 c = hh*w;

		 double x3_x = c(1,1)/c(3,1) ;
		 double x3_y = c(2,1)/c(3,1) ;

		 double dist = hypot(x3_x-x2(i+1,1),x3_y-x2(i+1,2));
			
		 printf("Dist error: %7.4f\n",dist);
	}
}

