
/*************************************************************************
	
	file created on:	2002/08/30   19:33
	filename: 			Bmp.cpp
	author:				Andreas Hartl

		visit http://www.runicsoft.com for updates and more information

	purpose:	functions to load raw bmp data,
	                      to save raw bmp data,
						  to convert RGB data to raw bmp data,
						  to convert raw bmp data to RGB data
						  and to use the WinAPI to select
							a bitmap into a device context

	file updated on 2010/09/13
		in the 8 years since i first wrote this the windows file functions
		have changed their input from char* to LPCTSTR. 
		Updated this in the code here

**************************************************************************/

#include <windows.h>
#include <stdio.h>       // for memset

BYTE* ConvertRGBToBMPBuffer ( BYTE* Buffer, int width, int height, long* newsize );
BYTE* ConvertBMPToRGBBuffer ( BYTE* Buffer, int width, int height );
bool LoadBMPIntoDC ( HDC hDC, LPCTSTR bmpfile );
bool SaveBMP ( BYTE* Buffer, int width, int height, long paddedsize, LPCTSTR bmpfile );
bool SaveBMP2( BYTE* Buffer, int width, int height, long paddedsize, LPCTSTR bmpfile, int bitCount);
BYTE* LoadBMP(int* width, int* height, long* size, LPCTSTR bmpfile);
void TestBMPCopy (LPCTSTR input, LPCTSTR output);
void TestBMPCopy2(LPCTSTR input, LPCTSTR output);
bool LoadBMPIntoDC2 ( HDC hDC, LPCTSTR bmpfile , int width, int height);
void DrawRawDataIntoDC(CDC* pDC, int x,int y, int dstWidth,int dstHeight, BYTE* pViewImg, int width,int height,int bitCount);
