
// cvCam2013Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "cvCam2013.h"
#include "cvCam2013Dlg.h"
#include "afxdialogex.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// 带 ϱ   Լ
BOOL m_bThreadFlag = FALSE;
UINT ThreadImageCaptureFunc(LPVOID param);


void FillBitmapInfo(BITMAPINFO* bmi, int width, int height, int bpp, int origin)
{
	assert(bmi&&width >= 0 && height >= 0 && (bpp == 8 || bpp == 24 || bpp == 32));
	BITMAPINFOHEADER *bmih = &(bmi->bmiHeader);
	memset(bmih, 0, sizeof(*bmih));
	bmih->biSize = sizeof(BITMAPINFOHEADER);
	bmih->biWidth = width;
	bmih->biHeight = origin ? abs(height) : -abs(height);
	bmih->biPlanes = 1;
	bmih->biBitCount = (unsigned short)bpp;
	bmih->biCompression = BI_RGB;
	if (bpp == 8) {
		RGBQUAD *palette = bmi->bmiColors;
		for (int i=0; i<256; i++)  {
			palette[i].rgbBlue = palette[i].rgbGreen = palette[i].rgbRed = (BYTE)i;
			palette[i].rgbReserved = 0;
		}
	}
}

void DisplayImage(CDC* pDC, CRect rect, Mat& srcimg)
{
	Mat img;
	int step = ((int)(rect.Width() / 4)) * 4; // 4byte 
	resize(srcimg, img, Size(step, rect.Height()));

	uchar buffer[sizeof(BITMAPINFOHEADER)* 1024];
	BITMAPINFO* bmi = (BITMAPINFO*)buffer;

	int bmp_w = img.cols;
	int bmp_h = img.rows;
	int depth = img.depth();
	int channels = img.channels();
	int bpp = 8 * channels;

	FillBitmapInfo(bmi, bmp_w, bmp_h, bpp, 0);

	int from_x = MIN(0, bmp_w - 1);
	int from_y = MIN(0, bmp_h - 1);
	int sw = MAX(MIN(bmp_w - from_x, rect.Width()), 0);
	int sh = MAX(MIN(bmp_h - from_y, rect.Height()), 0);

	SetDIBitsToDevice(pDC->m_hDC, rect.left, rect.top, sw, sh, from_x, from_y, 0, sh, img.data + from_y*img.step, bmi, 0);

	img.release();
}


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CcvCam2013Dlg dialog



CcvCam2013Dlg::CcvCam2013Dlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CcvCam2013Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CcvCam2013Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_VIEW, m_View);
	//  DDX_Control(pDX, IDC_BIN_IMAGE, m_BinImage);
	DDX_Control(pDX, IDC_BIN_IMAGE, m_BinView);
}

BEGIN_MESSAGE_MAP(CcvCam2013Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CAM_START, &CcvCam2013Dlg::OnBnClickedCamStart)
	ON_BN_CLICKED(IDC_CAM_STOP, &CcvCam2013Dlg::OnBnClickedCamStop)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BMP_LOAD, &CcvCam2013Dlg::OnBnClickedLoadBmp)
	ON_BN_CLICKED(IDC_BMP_SAVE, &CcvCam2013Dlg::OnBnClickedSaveBmp)
END_MESSAGE_MAP()


// CcvCam2013Dlg message handlers

BOOL CcvCam2013Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	
	// ī޶ 
	m_Capture.open(0);
	if (!m_Capture.isOpened()) AfxMessageBox(_T("There is no camera captured!"));

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CcvCam2013Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CcvCam2013Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();

		if (m_Image.data != NULL) {

			// ---------------------------------------------------------------
			// ī޶󿡼 о  ȭ鿡 ׸
			// ---------------------------------------------------------------
			CRect rect;
			CDC* pDC;
			pDC = m_View.GetDC();
			m_View.GetClientRect(rect);
			DisplayImage(pDC, rect, m_Image);
			ReleaseDC(pDC);


			// ---------------------------------------------------------------
			//  ҽ   ͸ ٷ  .
			//  imageData  ٷ ȯ   Ѵ. (unsigned char) 
			// ---------------------------------------------------------------

			// Į󿵻 ȭ Ѵ.
			Mat gray_img;
			cvtColor(m_Image, gray_img, COLOR_BGR2GRAY);
			pDC = m_BinView.GetDC();
			m_BinView.GetClientRect(rect);

			for (int y = 0; y < gray_img.rows; y++) {
				for (int x = 0; x < gray_img.cols; x++) {
					if ((unsigned char)gray_img.data[y*gray_img.step + x] > 100)
						gray_img.data[y*gray_img.step + x] = (unsigned char) 255;
					else
						gray_img.data[y*gray_img.step + x] = (unsigned char) 0;
				}
			}
			DisplayImage(pDC, rect, gray_img);
			ReleaseDC(pDC);			
		}
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CcvCam2013Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CcvCam2013Dlg::OnBnClickedCamStart()
{
	m_bThreadFlag = TRUE;
	CWinThread *pThread = ::AfxBeginThread(ThreadImageCaptureFunc, this);
}


void CcvCam2013Dlg::OnBnClickedCamStop()
{
	m_bThreadFlag = FALSE;
}


void CcvCam2013Dlg::OnDestroy()
{
	CDialogEx::OnDestroy();
}


UINT ThreadImageCaptureFunc(LPVOID param)
{
	CcvCam2013Dlg *pDlg = (CcvCam2013Dlg *)param;
	while (m_bThreadFlag)
	{
		//  ȹ
		pDlg->m_Capture >> pDlg->m_Image;
		pDlg->Invalidate(FALSE);
	}
	return 0;
}

void CcvCam2013Dlg::OnBnClickedLoadBmp()
{
	// TODO: Add your control notification handler code here

	wchar_t szFilter[] = _T("Image (*.BMP) | *.BMP;*.GIF;*.JPG | All Files(*.*)|*.*||");
	CFileDialog dlg(TRUE, _T("bmp"), _T("test"), OFN_HIDEREADONLY, szFilter);
	if (dlg.DoModal() == IDOK)
	{
		// ڵ ȯ
		//CT2CA pszConvertedAnsiString(dlg.GetPathName());
		std::string filename(CT2CA(dlg.GetPathName()));
		//String filename(dlg.GetPathName().GetBuffer(0));
		m_Image = imread(filename); // 1 for color
		Invalidate(FALSE);
	}
}


void CcvCam2013Dlg::OnBnClickedSaveBmp()
{
	// TODO: Add your control notification handler code here

	wchar_t szFilter[] = _T("Image (*.BMP) | *.BMP;*.GIF;*.JPG | All Files(*.*)|*.*||");
	CFileDialog dlg(FALSE, _T("bmp"), _T("test"), OFN_HIDEREADONLY, szFilter);
	if (dlg.DoModal() == IDOK)
	{
		flip(m_Image, m_Image, 0); // vertical
		std::string filename(CT2CA(dlg.GetPathName()));  // ڵ庯ȯ
		//CStringA filename(dlg.GetPathName().GetBuffer(0));
		imwrite(filename, m_Image);
	}

}
