
// baslerCam2013Dlg.cpp :  
//

#include "stdafx.h"
#include "baslerCam2013.h"
#include "baslerCam2013Dlg.h"
#include "afxdialogex.h"

//#pragma (disable:4996)

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

Image* m_pImage;							//	 ü
BOOL m_bThreadFlag;                          //   
UINT ThreadImageCaptureFunc(LPVOID param);   //  Լ
CInstantCamera *m_pCamera;                   // Basler Camera
CGrabResultPtr ptrGrabResult;                // This smart pointer will receive the grab result data.
//CInstantCamera *m_pCamera;
static const uint32_t c_countOfImagesToGrab = 100;	// Number of images to be grabbed.


//  α׷  Ǵ CAboutDlg ȭ Դϴ.

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// ȭ  Դϴ.
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV Դϴ.

// Դϴ.
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CbaslerCam2013Dlg ȭ 



CbaslerCam2013Dlg::CbaslerCam2013Dlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CbaslerCam2013Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pCamera = NULL;
}

void CbaslerCam2013Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_VIEW, m_View);
	DDX_Control(pDX, IDC_VIEW_BIN, m_ViewBin);
}

BEGIN_MESSAGE_MAP(CbaslerCam2013Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CAM_START, &CbaslerCam2013Dlg::OnBnClickedCamStart)
	ON_BN_CLICKED(IDC_CAM_STOP, &CbaslerCam2013Dlg::OnBnClickedCamStop)
	ON_BN_CLICKED(IDC_BMP_LOAD, &CbaslerCam2013Dlg::OnBnClickedBmpLoad)
	ON_BN_CLICKED(IDC_BMP_SAVE, &CbaslerCam2013Dlg::OnBnClickedBmpSave)
	ON_WM_TIMER()
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// CbaslerCam2013Dlg ޽ ó

BOOL CbaslerCam2013Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// ý ޴ "..." ޴ ׸ ߰մϴ.

	// IDM_ABOUTBOX ý   ־ մϴ.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	//  ȭ   մϴ.   α׷  â ȭ ڰ ƴ 쿡
	//  ӿũ  ۾ ڵ մϴ.
	SetIcon(m_hIcon, TRUE);			// ū  մϴ.
	SetIcon(m_hIcon, FALSE);		//   մϴ.

	// TODO: ⿡ ߰ ʱȭ ۾ ߰մϴ.
	
	// Before using any pylon methods, the pylon runtime must be initialized. 
	PylonInitialize();

	// Automagically call PylonInitialize and PylonTerminate to ensure the pylon runtime system
	// is initialized during the lifetime of this object.
	//Pylon::PylonAutoInitTerm autoInitTerm;

	// Get the transport layer factory.
	CTlFactory& tlFactory = CTlFactory::GetInstance();

	// Get all attached devices and exit application if no device is found.
	DeviceInfoList_t devices;
	if (tlFactory.EnumerateDevices(devices) == 0)
	{
		MessageBox(L"Basler Camera  ʾҽϴ.");
	}
	else {
		// create device
		//IPylonDevice *pDevice = TlFactory.CreateDevice(lstDevices[0]);

		// Create an instant camera object with the camera device found first.
		m_pCamera = new CInstantCamera(CTlFactory::GetInstance().CreateFirstDevice());
		INodeMap *m_pNodeMap; //GenericParameterAccess

		try
		{
			if (m_pCamera->IsOpen()) AfxMessageBox(_T("Camera is opened!"));
			else {
				//ī޶ ̺Ʈ ó  ȰȭǾմϴ, ⺻ Դϴ.
				m_pCamera->GrabCameraEvents = true;
				// ī޶ ߰ߵǾϴ. ϰ νƮ ī޶ ü մϴ.
				m_pCamera->Attach(tlFactory.CreateDevice(devices[0]));

				if (m_pCamera->IsPylonDeviceAttached())
				{
					m_pCamera->Open();

					m_pCamera->MaxNumBuffer = 1;
					m_pNodeMap = &m_pCamera->GetNodeMap();
					CIntegerPtr offsetX(m_pNodeMap->GetNode("OffsetX"));
					CIntegerPtr offsetY(m_pNodeMap->GetNode("OffsetY"));
					CIntegerPtr width(m_pNodeMap->GetNode("Width"));
					CIntegerPtr height(m_pNodeMap->GetNode("Height"));

					int new_width = 1024;
					int new_height = 624;

					width->SetValue(new_width);
					height->SetValue(new_height);
					offsetX->SetValue((int)(new_width / 2));
					offsetY->SetValue((int)(new_height / 2));

					CString str;
					str.Format(_T("Found camera: %s\nWidth: %d\nHeight: %d"),
						CString(m_pCamera->GetDeviceInfo().GetModelName()),
						width->GetValue(), height->GetValue());
					AfxMessageBox(str);

					m_pCamera->Close();
				}
			}
		}
		catch (GenICam::GenericException &e) //Error Handling
		{
			// Error handling
			CString strTrace;
			strTrace.Format(_T("Open_Camera - GenericException : %s\n"), (CString)e.GetDescription());
			AfxMessageBox(strTrace);
			return FALSE;
		}
	}

	return TRUE;  // Ŀ Ʈѿ   TRUE ȯմϴ.
}

void CbaslerCam2013Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// ȭ ڿ ּȭ ߸ ߰   ׸
//  Ʒ ڵ尡 ʿմϴ.  /  ϴ MFC  α׷ 쿡
//  ӿũ  ۾ ڵ մϴ.

void CbaslerCam2013Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // ׸⸦  ̽ ؽƮԴϴ.

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Ŭ̾Ʈ 簢   ϴ.
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  ׸ϴ.
		dc.DrawIcon(x, y, m_hIcon);
	}
	else 
	{
		CDialogEx::OnPaint();

		if (m_pImage != NULL) {

			// ---------------------------------------------------------------
			// ī޶󿡼 о  ȭ鿡 ׸
			// ---------------------------------------------------------------
			CRect rect;
			CDC* pDC;
			pDC = m_View.GetDC();
			m_View.GetClientRect(rect);
			DrawImage(&m_View, m_pImage);
			ReleaseDC(pDC);

			// ---------------------------------------------------------------------
			// Į󿵻 ȭ Ѵ.
			// ---------------------------------------------------------------------
			pDC = m_ViewBin.GetDC();
			m_ViewBin.GetClientRect(rect);

			Image* image2 = CreateImage(m_pImage->width, m_pImage->height);	// ο  
			for (int y = 0; y < image2->height; y++) {
				for (int x = 0; x < image2->width; x++) {
					if (m_pImage->imageData[y*m_pImage->width + x] > 100)
						image2->imageData[y*m_pImage->width + x] = 255;
					else
						image2->imageData[y*m_pImage->width + x] = 0;
				}
			}

			DrawImage(&m_ViewBin, image2);
			FreeImage(image2);
			ReleaseDC(pDC);
			// ---------------------------------------------------------------

		}
	}
}

// ڰ ּȭ â  ȿ Ŀ ǥõǵ ýۿ
//   Լ ȣմϴ.
HCURSOR CbaslerCam2013Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CbaslerCam2013Dlg::OnBnClickedCamStart()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	if (m_pCamera == NULL) {
		MessageBox(L"Basler Camera   ٽ ּ.");
		return;
	}

	m_pCamera->StartGrabbing();
	m_bThreadFlag = TRUE;
	CWinThread *pThread = ::AfxBeginThread(ThreadImageCaptureFunc, this);

}


void CbaslerCam2013Dlg::OnBnClickedCamStop()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	if (m_pCamera == NULL) {
		MessageBox(L"Basler Camera   ٽ ּ.");
		return;
	}

	m_pCamera->StopGrabbing();
	m_bThreadFlag = FALSE;
		
}


void CbaslerCam2013Dlg::OnBnClickedBmpLoad()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.

	wchar_t szFilter[] = _T("Image (*.BMP) | *.BMP;*.GIF;*.JPG | All Files(*.*)|*.*||");
	CFileDialog dlg(TRUE, _T("bmp"), _T("test"), OFN_HIDEREADONLY, szFilter);
	if (dlg.DoModal() == IDOK)
	{
		CRect rect;
		//m_View.GetWindowRect(&rect);
		//LoadBMPIntoDC2(::GetDC(m_View.GetSafeHwnd()), dlg.GetPathName().GetBuffer(0), rect.Width(), rect.Height());
		//CStringA filename(dlg.GetPathName());
		if (m_pImage != NULL) delete m_pImage;
		m_pImage = LoadBMP(dlg.GetPathName().GetBuffer(0));
		if (m_pImage == NULL) MessageBox(L"   ϴ.  24Ʈ ϸ մϴ.");
		Invalidate(FALSE);
	}
}


void CbaslerCam2013Dlg::OnBnClickedBmpSave()
{
	// TODO: ⿡ Ʈ ˸ ó ڵ带 ߰մϴ.
	if (m_pImage == NULL) {
		MessageBox(L"  ϴ."); 
		return;
	}

	wchar_t szFilter[] = _T("Image (*.BMP) | *.BMP;*.GIF;*.JPG | All Files(*.*)|*.*||");
	CFileDialog dlg(FALSE, _T("bmp"), _T("test"), OFN_HIDEREADONLY, szFilter);
	if (dlg.DoModal() == IDOK)
	{
		//cvFlip(m_pImage, m_pImage, 0); // vertical
		//CStringA filename(dlg.GetPathName());
		//cvSaveImage(filename, m_pImage);
		//SaveBMP2((BYTE*)ptrGrabResult->GetBuffer(), m_pImage->width, m_pImage->height, 
		//	dlg.GetPathName().GetBuffer(0) );
		SaveBMP(m_pImage, dlg.GetPathName().GetBuffer(0) );
	}
}


void CbaslerCam2013Dlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: ⿡ ޽ ó ڵ带 ߰ /Ǵ ⺻ ȣմϴ.

	CDialogEx::OnTimer(nIDEvent);
}


void CbaslerCam2013Dlg::OnDestroy()
{
	CDialogEx::OnDestroy();

	// Releases all pylon resources. 
	PylonTerminate();

	if (m_pCamera != NULL) delete m_pCamera;
	if (m_pImage!=NULL) FreeImage(m_pImage);
}


UINT ThreadImageCaptureFunc(LPVOID param)
{
	CbaslerCam2013Dlg *pDlg = (CbaslerCam2013Dlg *)param;
	if (m_pCamera == NULL) return 0;

	while (m_bThreadFlag)
	{
		//  ȹ
		// m_pCamera->StopGrabbing() is called automatically by the RetrieveResult() method
		// when c_countOfImagesToGrab images have been retrieved.
		try
		{
			if (m_pCamera->IsGrabbing())
			{
				// Wait for an image and then retrieve it. A timeout of 5000 ms is used.
				m_pCamera->RetrieveResult(5000, ptrGrabResult, TimeoutHandling_ThrowException);

				// Image grabbed successfully?
				if (ptrGrabResult->GrabSucceeded())
				{
					// Access the image data.
					const uint8_t *pImageBuffer = (uint8_t *)ptrGrabResult->GetBuffer();
					if (m_pImage == NULL) {
						m_pImage = CreateImage(ptrGrabResult->GetWidth(), ptrGrabResult->GetHeight());
					}
					memcpy(m_pImage->imageData, pImageBuffer, ptrGrabResult->GetWidth() * ptrGrabResult->GetHeight());
				}
				else {
					CString str;
					str.Format(_T("Error: %d %s", 
						CString(ptrGrabResult->GetErrorCode()), 
						CString(ptrGrabResult->GetErrorDescription())) );
					AfxMessageBox(str);
				}
				pDlg->Invalidate(FALSE);
			}

		}
		catch (GenICam::GenericException &e)
		{
			cerr << "An exception occurred. " << e.GetDescription() << endl;
		}
	}

	return 0;
}
