#include "stdafx.h"

/*
 ҽ ̿Ͽ ī޶   α׷ Ѵ.
⼭ ϴ  ü Image ̴.
 α׷  Bmp ó ҽ̴.  bmp α׷ SimpleBmp.cpp/*.h ̴.

 ҽ BMP RGB  Ȯ  ʴ´. , LoadBmp  Ѵ.
BMP: widthByte*height,  color:BGR, upside-down
RGB: width*height,  color:RGB

2015. 01.25
2016. 03.21  channel ߰ .   DrawImage() Լ 
2016. 12.05  SaveBmp() - widthBytes 4byte size   
2017. 01.16  LoadBmp, SaveBmp   Ŵ
2018. 01.02  LoadBmp, SaveBmp bitcount 8   
*/


/*************************************************************************
	
	file created on:	2002/08/30   19:33
	filename: 			Bmp.cpp
	author:				Andreas Hartl

		visit http://www.runicsoft.com for updates and more information

	purpose:	functions to load raw bmp data,
	                      to save raw bmp data,
						  to convert RGB data to raw bmp data,
						  to convert raw bmp data to RGB data
						  and to use the WinAPI to select
							a bitmap into a device context

	file updated on 2010/09/13
		in the 8 years since i first wrote this the windows file functions
		have changed their input from char* to LPCTSTR. 
		Updated this in the code here

**************************************************************************/

#include <windows.h>
#include <stdio.h>       // for memset
#include <malloc.h>
#include "bmp.h"

#define WIDTHBYTES(bits)  (((bits)+31)/32*4)

/*******************************************************************
BYTE* ConvertRGBToBMPBuffer ( BYTE* Buffer, int width, 
		int height, long* newsize )


This function takes as input an array of RGB values, it's width
and height.
The buffer gets then transformed to an array that can be used
to write to a windows bitmap file. The size of the array
is returned in newsize, the array itself is the
return value of the function.
Both input and output buffers must be deleted by the
calling function.

The input buffer is expected to consist of width * height
RGB triplets. Thus the total size of the buffer is taken as
width * height * 3.

The function then transforms this buffer so that it can be written 
to a windows bitmap file:
First the RGB triplets are converted to BGR.
Then the buffer is swapped around since .bmps store
images uside-down.
Finally the buffer gets DWORD ( 32bit ) aligned, 
meaning that each scanline ( 3 * width bytes ) gets
padded with 0x00 bytes up to the next DWORD boundary


*******************************************************************/

Image* CreateImage(int width, int height)
{
	return CreateImage2(width, height, 1);
}

Image* CreateImage3(int width, int height)
{
	return CreateImage2(width, height, 3);
}



Image* CreateImage2(int width, int height, int channel)
{
	Image* img = new Image;
	img->width = width;
	img->height = height;
	img->channel = channel;
	img->widthBytes = WIDTHBYTES(width * channel * 8);
	img->imageData = new BYTE[width*height*channel];
	return img;
}

void FreeImage(Image* img)
{
	delete[] img->imageData;
	delete img;
	img = NULL;
}

void CopyImage(Image* src, Image* dst)
{
	if (dst == NULL) return;
	dst->width = src->width;
	dst->height = src->height;
	dst->widthBytes = src->widthBytes;
	memcpy(dst->imageData, src->imageData, sizeof(BYTE)*src->width*src->height);
}

BYTE* ConvertRGBToBMPBuffer(BYTE* Buffer, int width, int height, long* newsize)
{

	// first make sure the parameters are valid
	if ( ( NULL == Buffer ) || ( width == 0 ) || ( height == 0 ) )
		return NULL;

	// now we have to find with how many bytes
	// we have to pad for the next DWORD boundary	

	int padding = 0;
	int scanlinebytes = width * 3;
	while ( ( scanlinebytes + padding ) % 4 != 0 )     // DWORD = 4 bytes
		padding++;
	// get the padded scanline width
	int psw = scanlinebytes + padding;
	
	// we can already store the size of the new padded buffer
	*newsize = height * psw;

	// and create new buffer
	BYTE* newbuf = new BYTE[*newsize];
	
	// fill the buffer with zero bytes then we dont have to add
	// extra padding zero bytes later on
	memset ( newbuf, 0, *newsize );

	// now we loop trough all bytes of the original buffer, 
	// swap the R and B bytes and the scanlines
	long bufpos = 0;   
	long newpos = 0;
	for ( int y = 0; y < height; y++ )
		for ( int x = 0; x < 3 * width; x+=3 )
		{
			bufpos = y * 3 * width + x;     // position in original buffer
			newpos = ( height - y - 1 ) * psw + x;           // position in padded buffer

			newbuf[newpos] = Buffer[bufpos+2];       // swap r and b
			newbuf[newpos + 1] = Buffer[bufpos + 1]; // g stays
			newbuf[newpos + 2] = Buffer[bufpos];     // swap b and r
		}

	return newbuf;
}

/***************************************************************
BYTE* ConvertBMPToRGBBuffer ( BYTE* Buffer, 
		int width, int height )

This function takes as input the data array
from a bitmap and its width and height.
It then converts the bmp data into an RGB array.
The calling function must delete both the input
and output arrays.
The size of the returned array will be 
width * height * 3
On error the returb value is NULL, else the
RGB array.


The Buffer is expected to be the exact data read out
from a .bmp file.  
The function will swap it around, since images
are stored upside-down in bmps.
The BGR triplets from the image data will
be converted to RGB.
And finally the function removes padding bytes.
The returned arraay consits then of
width * height RGB triplets.

*****************************************************************/

BYTE* ConvertBMPToRGBBuffer ( BYTE* Buffer, int width, int height )
{
	// first make sure the parameters are valid
	if ( ( NULL == Buffer ) || ( width == 0 ) || ( height == 0 ) )
		return NULL;

	// find the number of padding bytes
		
	int padding = 0;
	int scanlinebytes = width * 3;
	while ( ( scanlinebytes + padding ) % 4 != 0 )     // DWORD = 4 bytes
		padding++;
	// get the padded scanline width
	int psw = scanlinebytes + padding;

	// create new buffer
	BYTE* newbuf = new BYTE[width*height*3];
	
	// now we loop trough all bytes of the original buffer, 
	// swap the R and B bytes and the scanlines
	long bufpos = 0;   
	long newpos = 0;
	for ( int y = 0; y < height; y++ )
		for ( int x = 0; x < 3 * width; x+=3 )
		{
			newpos = y * 3 * width + x;     
			bufpos = ( height - y - 1 ) * psw + x;

			newbuf[newpos] = Buffer[bufpos + 2];       
			newbuf[newpos + 1] = Buffer[bufpos+1]; 
			newbuf[newpos + 2] = Buffer[bufpos];     
		}

	return newbuf;
}





/***********************************************
bool LoadBMPIntoDC ( HDC hDC, LPCTSTR bmpfile )

Takes in a device context and the name of a
bitmap to load. If an error occurs the function
returns false, else the contents of the bmp
are blitted to the HDC 

************************************************/


bool LoadBMPIntoDC ( HDC hDC, LPCTSTR bmpfile )
{
		// check if params are valid 
	if ( ( NULL == hDC  ) || ( NULL == bmpfile ) )
		return false;      

	// load bitmap into a bitmap handle
	HANDLE hBmp = LoadImage ( NULL, bmpfile, IMAGE_BITMAP, 0, 0,
		LR_LOADFROMFILE );
	
	if ( NULL == hBmp )
		return false;        // failed to load image
 
	// bitmaps can only be selected into memory dcs:
	HDC dcmem = CreateCompatibleDC ( NULL );

	// now select bitmap into the memory dc
	if ( NULL == SelectObject ( dcmem, hBmp ) )
	{	// failed to load bitmap into device context
		DeleteDC ( dcmem ); 
		return false; 
	}

	
	// now get the bmp size
	BITMAP bm;
	GetObject ( hBmp, sizeof(bm), &bm );
	// and blit it to the visible dc
	if ( BitBlt ( hDC, 0, 0, bm.bmWidth, bm.bmHeight, dcmem, 0, 0, SRCCOPY ) == 0 )
	{	// failed the blit
		DeleteDC ( dcmem ); 
		return false; 
	}
		   	
	DeleteDC ( dcmem );  // clear up the memory dc
	
	return true;
}

bool LoadBMPIntoDC2 ( HDC hDC, LPCTSTR bmpfile , int width, int height)
{
	// check if params are valid 
	if ( ( NULL == hDC  ) || ( NULL == bmpfile ) )
		return false;      

	// load bitmap into a bitmap handle
	HANDLE hBmp = LoadImage ( NULL, bmpfile, IMAGE_BITMAP, 0, 0,
		LR_LOADFROMFILE );
	
	if ( NULL == hBmp )
		return false;        // failed to load image
 
	// bitmaps can only be selected into memory dcs:
	HDC dcmem = CreateCompatibleDC ( NULL );

	// now select bitmap into the memory dc
	if ( NULL == SelectObject ( dcmem, hBmp ) )
	{	// failed to load bitmap into device context
		DeleteDC ( dcmem ); 
		return false; 
	}

	
	// now get the bmp size
	BITMAP bm;
	GetObject ( hBmp, sizeof(bm), &bm );
	// and blit it to the visible dc
	SetStretchBltMode(hDC, COLORONCOLOR);
	if ( StretchBlt ( hDC, 0, 0,width, height, dcmem, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY ) == 0 )
	{	// failed the blit
		DeleteDC ( dcmem ); 
		return false; 
	}
		   	
	DeleteDC ( dcmem );  // clear up the memory dc
	
	return true;
}

void DrawImage(CWnd*  pWnd, Image* pImage)
{
	CRect rect;
	CDC* pDC;
	pDC = pWnd->GetDC();
	pWnd->GetClientRect(rect);

	DrawRawDataIntoDC(pDC, 0, 0, rect.Width(), rect.Height(),
		pImage->imageData, pImage->width, pImage->height, pImage->channel * 8);
	pWnd->ReleaseDC(pDC);
}


void DrawImage(CWnd*  pWnd, int x, int y, int dstWidth, int dstHeight, Image* pImage)
{
	
	CDC* pDC;
	pDC = pWnd->GetDC();
	

	DrawRawDataIntoDC(pDC, x, y, dstWidth, dstHeight,
		pImage->imageData, pImage->width, pImage->height, pImage->channel*8);
	pWnd->ReleaseDC(pDC);
}



SimpleBmp::SimpleBmp()
{
	m_Init = FALSE;
	m_pImage = NULL;
	m_pDC = NULL;
	m_pWnd = NULL;
	isDrawing = FALSE;
	m_pBmpInfo = (BITMAPINFO*) new BYTE[sizeof(BITMAPINFOHEADER)+(256 * sizeof(RGBQUAD))];
}

SimpleBmp::~SimpleBmp()
{
	delete []m_pBmpInfo;
	delete m_pImage;
	//if(m_pWnd!=NULL && m_pDC!=NULL) m_pWnd->ReleaseDC(m_pDC);

}

void SimpleBmp::SetHeaderInfo(int width, int height, int bitCount)
{
	m_pBmpInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	m_pBmpInfo->bmiHeader.biPlanes = 1;
	m_pBmpInfo->bmiHeader.biCompression = 0; //BI_RGB;// 0;  
	m_pBmpInfo->bmiHeader.biWidth = width; //̹  ũ⸦ .  
	m_pBmpInfo->bmiHeader.biHeight = height;
	m_pBmpInfo->bmiHeader.biBitCount = bitCount;
	m_pBmpInfo->bmiHeader.biXPelsPerMeter = 0;
	m_pBmpInfo->bmiHeader.biYPelsPerMeter = 0;
	m_pBmpInfo->bmiHeader.biClrUsed = 256;
	m_pBmpInfo->bmiHeader.biClrImportant = 0;//SHRT_MAX;  
	m_pBmpInfo->bmiHeader.biSizeImage = height * WIDTHBYTES(width * bitCount);

	if (bitCount == 8)
	{
		for (int i = 0; i < 256; i++)
		{
			m_pBmpInfo->bmiColors[i].rgbBlue = i;
			m_pBmpInfo->bmiColors[i].rgbGreen = i;
			m_pBmpInfo->bmiColors[i].rgbRed = i;
			m_pBmpInfo->bmiColors[i].rgbReserved = 0;
		}
	}
}


void SimpleBmp::Draw(CWnd*  pWnd, Image* pImage)
{
	m_pWnd = pWnd;
	if (!m_pDC) {
		m_pDC = pWnd->GetDC();
		pWnd->GetClientRect(m_rect);
	}
	Draw(m_pDC, 0, 0, m_rect.Width(), m_rect.Height(),
		pImage->imageData, pImage->width, pImage->height, pImage->channel * 8);
}

void SimpleBmp::Draw(CDC* pDC, int x, int y, int dstWidth, int dstHeight, BYTE* pViewImg, int width, int height, int bitCount)
{
	if (isDrawing) return;
	isDrawing = TRUE;

	//pViewImg  RAW DATA
	if (pViewImg == NULL) return;
	

	//ȭ鿡 ϱ  ޸𸮿  Ѵ. , Ʈ ü .

	CBitmap bitMap, *pOldBitmap;
	if (!m_Init) {
		//  ʱȭ
		SetHeaderInfo(width, height, bitCount);

		// ȣȯǴ memDC ޸𸮿 Ѵ.  
		m_memDC.CreateCompatibleDC(pDC);
		bitMap.CreateCompatibleBitmap(pDC, width, height);
		pOldBitmap = (CBitmap*)m_memDC.SelectObject(&bitMap);
		m_memDC.SelectObject(&bitMap);
		CRect rect;
		//m_memDC.FillSolidRect(&rect, RGB(255, 255, 255));

		m_pImage = new BYTE[m_pBmpInfo->bmiHeader.biSizeImage];
		m_Init = TRUE;
	}
	

	// image 
	int widthBytes = WIDTHBYTES(width * bitCount);
	for (int i = 0; i < height; i++) {
		for (int j = 0; j < widthBytes; j++) {
			m_pImage[i*widthBytes + j] = pViewImg[(height - i - 1)* widthBytes + j];
		}
	}

	SetDIBitsToDevice(
		m_memDC.GetSafeHdc(), // Handle to the device context.  
		0, 0, // Specifies the x and y-coordinate, in logical units, of the upper-left corner of the destination rectangle.  
		width, height, //, θ ´.  
		// Specifies the width and height, in logical units, of the DIB.  
		0, 0, // Specifies the x and y-coordinate, in logical units, of the lower-left corner of the DIB.  
		0, // Specifies the starting scan line in the DIB.  
		height, //θ . // Specifies the number of DIB scan lines contained in the array pointed to by the lpvBits parameter.  
		m_pImage, m_pBmpInfo, DIB_RGB_COLORS);

	//StretchBltMode .  
	pDC->SetStretchBltMode(COLORONCOLOR);

	//dc.BitBlt(0, 0, rectLP.right, rectLP.bottom, &memDC,0, 0, SRCCOPY);  
	pDC->StretchBlt(x, y, dstWidth, dstHeight, &m_memDC, 0, 0, width, height, SRCCOPY);
	//pDC->BitBlt(x,y,width, height, &m_memDC, 0,0,SRCCOPY); 

	isDrawing = FALSE;
}

void DrawRawDataIntoDC(CDC* pDC, int x, int y, int dstWidth, int dstHeight, BYTE* pViewImg, int width, int height, int bitCount)
{ 
	BITMAPINFO *pBmpInfo = NULL; 
	if(pBmpInfo == NULL) 
		pBmpInfo = (BITMAPINFO*) new BYTE[sizeof(BITMAPINFOHEADER) + (256 * sizeof(RGBQUAD))]; 
	

	pBmpInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER); 
	pBmpInfo->bmiHeader.biPlanes = 1; 
	pBmpInfo->bmiHeader.biCompression = 0; //BI_RGB;// 0;  
	pBmpInfo->bmiHeader.biWidth = width; //̹  ũ⸦ .  
	pBmpInfo->bmiHeader.biHeight = height; 
	pBmpInfo->bmiHeader.biBitCount = bitCount; 
	pBmpInfo->bmiHeader.biXPelsPerMeter = 0; 
	pBmpInfo->bmiHeader.biYPelsPerMeter = 0; 
	pBmpInfo->bmiHeader.biClrUsed = 256; 
	pBmpInfo->bmiHeader.biClrImportant = 0;//SHRT_MAX;  
	pBmpInfo->bmiHeader.biSizeImage =height * WIDTHBYTES( width * bitCount ); 
	
	if(bitCount==8)
	{
		for(int i = 0; i < 256; i++) 
		{ 
			pBmpInfo->bmiColors[i].rgbBlue = i; 
			pBmpInfo->bmiColors[i].rgbGreen = i; 
			pBmpInfo->bmiColors[i].rgbRed = i; 
			pBmpInfo->bmiColors[i].rgbReserved= 0; 
		} 
	}

	//pViewImg  RAW DATA
	if(pViewImg != NULL) 
	{ 
		//ȭ鿡 ϱ  ޸𸮿  Ѵ. , Ʈ ü .  
		CRect rect;
		CDC memDC; 
		CBitmap bitMap, *pOldBitmap; 

		// ȣȯǴ memDC ޸𸮿 Ѵ.  
		memDC.CreateCompatibleDC(pDC); 
		bitMap.CreateCompatibleBitmap(pDC, width, height); 
		pOldBitmap = (CBitmap*)memDC.SelectObject(&bitMap); 
		memDC.SelectObject(&bitMap); 
		memDC.FillSolidRect(&rect, RGB(255, 255, 255)); 

		// image 
		int size = pBmpInfo->bmiHeader.biSizeImage;
		LPBYTE pImage = (LPBYTE)malloc(size);
		memcpy(pImage, pViewImg, size);
		int widthBytes = WIDTHBYTES(width * bitCount);
		for (int i = 0; i < height / 2; i++) {
			for (int j = 0; j < widthBytes; j++) {
				char temp = pImage[i*widthBytes + j];
				pImage[i*widthBytes + j] = pImage[(height - i - 1)* widthBytes + j];
				pImage[(height - i - 1)* widthBytes + j] = temp;
			}
		}

		
		SetDIBitsToDevice( 
			memDC.GetSafeHdc(), // Handle to the device context.  
			0, 0, // Specifies the x and y-coordinate, in logical units, of the upper-left corner of the destination rectangle.  
			width, height, //, θ ´.  
			// Specifies the width and height, in logical units, of the DIB.  
			0, 0, // Specifies the x and y-coordinate, in logical units, of the lower-left corner of the DIB.  
			0, // Specifies the starting scan line in the DIB.  
			height, //θ . // Specifies the number of DIB scan lines contained in the array pointed to by the lpvBits parameter.  
			pImage, pBmpInfo, DIB_RGB_COLORS);

		//StretchBltMode .  
		pDC->SetStretchBltMode(COLORONCOLOR); 
		
		//dc.BitBlt(0, 0, rectLP.right, rectLP.bottom, &memDC,0, 0, SRCCOPY);  
		pDC->StretchBlt(x,y, dstWidth, dstHeight, &memDC, 0, 0, width, height, SRCCOPY);  
		//pDC->BitBlt(x,y,width, height, &memDC, 0,0,SRCCOPY); 
		

		// free
		free(pImage);
	} 


	if(pBmpInfo != NULL) 
	{ 
		delete [] pBmpInfo; 
		pBmpInfo = NULL;
	}
} 

/***************************************************************
bool SaveBMP ( BYTE* Buffer, int width, int height, 
		long paddedsize, LPCTSTR bmpfile )

Function takes a buffer of size <paddedsize> 
and saves it as a <width> * <height> sized bitmap 
under the supplied filename.
On error the return value is false.

***************************************************************/

//  ʹ 8bit Ѵ
bool SaveBMP(Image* src, LPCTSTR bmpfile)
{
	return SaveBMP2(
		src->imageData, 
		src->width, src->height, 
		bmpfile, src->channel*8);
}

bool SaveBMP2(BYTE* Buffer, int width, int height, LPCTSTR bmpfile, int bitCount)
{
	// declare bmp structures 
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER info;
	
	// andinitialize them to zero
	memset ( &bmfh, 0, sizeof (BITMAPFILEHEADER ) );
	memset ( &info, 0, sizeof (BITMAPINFOHEADER ) );
	
	long widthBytes = WIDTHBYTES(width * bitCount);
	long bufSize = widthBytes*height;
	long palSize = ((bitCount == 8) ? 256 * sizeof(RGBQUAD) : 0); // palette size

	// fill the fileheader with data
	bmfh.bfType = 0x4d42;       // 0x4d42 = 'BM'
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfSize = sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER) + bufSize + palSize;
	bmfh.bfOffBits = 0x36 + palSize;		// number of bytes to start of bitmap bits
	
	// fill the infoheader
	info.biSize = sizeof(BITMAPINFOHEADER);
	info.biWidth = width;
	info.biHeight = height;
	info.biPlanes = 1;			// we only have one bitplane
	info.biBitCount = bitCount;		// RGB mode is 24 bits
	info.biCompression = 0;			// BI_RGB;
	info.biSizeImage = bufSize;		// can be 0 for 24 bit images
	info.biXPelsPerMeter = 0x0ec4;		// paint and PSP use this values
	info.biYPelsPerMeter = 0x0ec4;     
	info.biClrUsed = (bitCount==8) ? 256 : 0;	// we are in RGB mode and have no palette
	info.biClrImportant = (bitCount == 8) ? 256 : 0;    // all colors are important

	// now we open the file to write to
	HANDLE file = CreateFile ( bmpfile , GENERIC_WRITE, FILE_SHARE_READ,
		 NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
	if ( file == NULL )
	{
		CloseHandle ( file );
		AfxMessageBox(_T("Error save bmp!(-1)"));
		return false;
	}
	
	// write file header
	unsigned long bwritten;
	if ( WriteFile ( file, &bmfh, sizeof ( BITMAPFILEHEADER ), &bwritten, NULL ) == false )
	{	
		CloseHandle ( file );
		AfxMessageBox(_T("Error save bmp!(-2)"));
		return false;
	}
	// write infoheader
	if ( WriteFile ( file, &info, sizeof ( BITMAPINFOHEADER ), &bwritten, NULL ) == false )
	{	
		CloseHandle ( file );
		AfxMessageBox(_T("Error save bmp!(-3)"));
		return false;
	}

	// write palette
	if (bitCount == 8)
	{
		RGBQUAD *bmiColors = (RGBQUAD*) new BYTE[(256 * sizeof(RGBQUAD))];
		for (int i = 0; i < 256; i++)
		{
			bmiColors[i].rgbBlue = i;
			bmiColors[i].rgbGreen = i;
			bmiColors[i].rgbRed = i;
			bmiColors[i].rgbReserved = 0;
		}
		if (WriteFile(file, bmiColors, (256 * sizeof(RGBQUAD)), &bwritten, NULL) == false)
		{
			CloseHandle(file);
			AfxMessageBox(_T("Error save bmp!(-4)"));
			return false;
		}
		delete bmiColors;
	}

	// reverse image
	BYTE temp;
	for (int i = 0; i < height / 2; i++) {
		for (int j = 0; j < widthBytes; j++) {
			temp = Buffer[i*widthBytes + j];
			Buffer[i*widthBytes + j] = Buffer[(height - i - 1)* widthBytes + j];
			Buffer[(height - i - 1)* widthBytes + j] = temp;
		}
	}
	
	// write image data
	if (WriteFile(file, Buffer, bufSize, &bwritten, NULL) == false)
	{	
		CloseHandle ( file );
		CString str;
		str.Format(_T("Error save bmp!(%d)"), GetLastError());
		AfxMessageBox(str);
		return false;
	}
	
	// and close file
	CloseHandle ( file );

	return true;
}

/*******************************************************************
BYTE* LoadBMP ( int* width, int* height, long* size 
		LPCTSTR bmpfile )

The function loads a 24 bit bitmap from bmpfile, 
stores it's width and height in the supplied variables
and the whole size of the data (padded) in <size>
and returns a buffer of the image data 

On error the return value is NULL. 

  NOTE: make sure you [] delete the returned array at end of 
		program!!!
*******************************************************************/

Image* LoadBMP(LPCTSTR bmpfile)
{
	Image* image = new Image;
	image->imageData = LoadBMP2(&image->width, &image->height, &image->channel, bmpfile);
	if (image->imageData == NULL) {
		delete image;
		return NULL;
	}
	image->widthBytes = WIDTHBYTES((image->width) * (image->channel) * 8);

	return image;
}

BYTE* LoadBMP2 ( int* width, int* height, int* channel, LPCTSTR bmpfile )
{
	// declare bitmap structures
	BITMAPFILEHEADER bmpheader;
	BITMAPINFOHEADER bmpinfo;
	// value to be used in ReadFile funcs
	DWORD bytesread;
	// open file to read from
	HANDLE file = CreateFile ( bmpfile , GENERIC_READ, FILE_SHARE_READ,
		 NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL );
	if ( NULL == file )
		return NULL; // coudn't open file
	
	
	// read file header
	if ( ReadFile ( file, &bmpheader, sizeof ( BITMAPFILEHEADER ), &bytesread, NULL ) == false )
	{
		CloseHandle ( file );
		return NULL;
	}

	//read bitmap info
	if ( ReadFile ( file, &bmpinfo, sizeof ( BITMAPINFOHEADER ), &bytesread, NULL ) == false )
	{
		CloseHandle ( file );
		return NULL;
	}

	// check if file is actually a bmp
	if ( bmpheader.bfType != 'MB' )
	{
		CloseHandle ( file );
		return NULL;
	}

	// get image measurements
	*width   = bmpinfo.biWidth;
	*height  = abs ( bmpinfo.biHeight );
	*channel = bmpinfo.biBitCount / 8;

	// check if bmp is uncompressed
	if ( bmpinfo.biCompression != BI_RGB )
	{
		CloseHandle ( file );
		return NULL;
	}

	
	// check if we have 24 bit and 8bit bmp
	if (bmpinfo.biBitCount != 24 && bmpinfo.biBitCount != 8)
	{
		CloseHandle ( file );
		return NULL;
	}
	

	// create buffer to hold the data
	long size = bmpheader.bfSize - bmpheader.bfOffBits;
	BYTE* Buffer = new BYTE[ size ];
	// move file pointer to start of bitmap data
	SetFilePointer(file, bmpheader.bfOffBits, NULL, FILE_BEGIN);
	// read bmp data
	if ( ReadFile ( file, Buffer, size, &bytesread, NULL ) == false )
	{
		delete [] Buffer;
		CloseHandle ( file );
		return NULL;
	}

	// everything successful here: close file and return buffer
	CloseHandle(file);

	// 24 Ʈΰ 8Ʈ(gray color) ȯѴ.
	//if (bmpinfo.biBitCount == 24)
	//{
	//	long size = (*width) * (*height);
	//	BYTE* Buffer2 = new BYTE[size];
	//	for (int i = 0; i < size; i++) {
	//		Buffer2[i] = (Buffer[i*3+0] + Buffer[i*3+1] + Buffer[i*3+2])/3;
	//	}
	//	delete[] Buffer;

	//	*channel = 1;  // gray
	//	return Buffer2;
	//}

	// reverse image
	int widthBytes = WIDTHBYTES((*width) * bmpinfo.biBitCount);
	BYTE temp;
	for (int i = 0; i < *height / 2; i++) {
		for (int j = 0; j < widthBytes; j++) {
			temp = Buffer[i*widthBytes + j];
			Buffer[i*widthBytes + j] = Buffer[(*height - i - 1)* widthBytes + j];
			Buffer[(*height - i - 1)* widthBytes + j] = temp;
		}
	}


	return Buffer;
}

void TestBMPCopy (LPCTSTR input, LPCTSTR output)
{
	Image* a = LoadBMP(input);
	Image* b = CreateImage(a->width, a->height);
	CopyImage(a, b);
	SaveBMP(b, output);
	delete[] a;
	delete[] b;
}

void TestBMPCopy2(LPCTSTR input, LPCTSTR output)
{
	Image* a = LoadBMP( input );
	Image* b = CreateImage(a->width, a->height);
	CopyImage(a, b);

	// ȭ óѴ.
	for (int y = 0; y < a->height; y++) {
		for (int x = 0; x < a->width; x++) {
			if (a->imageData[y*a->width + x] > 100)
				b->imageData[y*b->width + x] = 255;
			else
				b->imageData[y*b->width + x] = 0;
		}
	}

	SaveBMP ( b, output );
	delete [] a;
	delete [] b;
}

/*
void main ()
{
	// TestBMPCopy (L"test.bmp", L"copy.bmp");
	TestBMPCopy2 (L"test.bmp", L"copy.bmp");
}
*/