
/*************************************************************************
	
	file created on:	2002/08/30   19:33
	filename: 			Bmp.cpp
	author:				Andreas Hartl

		visit http://www.runicsoft.com for updates and more information

	purpose:	functions to load raw bmp data,
	                      to save raw bmp data,
						  to convert RGB data to raw bmp data,
						  to convert raw bmp data to RGB data
						  and to use the WinAPI to select
							a bitmap into a device context

	file updated on 2010/09/13
		in the 8 years since i first wrote this the windows file functions
		have changed their input from char* to LPCTSTR. 
		Updated this in the code here

**************************************************************************/

#include <windows.h>
#include <stdio.h>       // for memset


// 2016. 1. 25 C.H.Han
// image ü 8bit ÷ Ѵ. bmp аų Ҷ  8bit ȯϰ ȴ.

typedef struct image {
	int width;
	int height;
	int channel;
	int widthBytes;	// ʺ Ʈ
	BYTE* imageData;
} Image;


// ߰ Լ
Image* LoadBMP(LPCTSTR bmpfile);
Image* CreateImage(int width, int height);
Image* CreateImage2(int width, int height, int channel);

Image* CreateImage3(int width, int height);

BYTE* CreateByte(int width, int height);
void FreeImage(Image* img);
void DrawImage(CWnd* pWnd, int x, int y, int dstWidth, int dstHeight, Image* pImage);
void DrawImage(CWnd* pWnd, Image* pImage);


//  Լ
BYTE* ConvertRGBToBMPBuffer ( BYTE* Buffer, int width, int height, long* newsize );
BYTE* ConvertBMPToRGBBuffer ( BYTE* Buffer, int width, int height );
bool LoadBMPIntoDC ( HDC hDC, LPCTSTR bmpfile );
bool SaveBMP(Image* src, LPCTSTR bmpfile);
bool SaveBMP2( BYTE* Buffer, int width, int height, LPCTSTR bmpfile, int bitCount);
Image* LoadBMP(LPCTSTR bmpfile);
BYTE* LoadBMP2(int* width, int* height, int* size, LPCTSTR bmpfile);
void TestBMPCopy (LPCTSTR input, LPCTSTR output);
void TestBMPCopy2(LPCTSTR input, LPCTSTR output);
bool LoadBMPIntoDC2 ( HDC hDC, LPCTSTR bmpfile , int width, int height);
void DrawRawDataIntoDC(CDC* pDC, int x,int y, int dstWidth,int dstHeight, BYTE* pViewImg, int width,int height,int bitCount);


class SimpleBmp
{
	BITMAPINFO *m_pBmpInfo;
	CDC m_memDC;
	LPBYTE m_pImage;
	BOOL m_Init;
	CDC* m_pDC;
	CWnd* m_pWnd;
	CRect m_rect;
	BOOL isDrawing;

public:
	SimpleBmp();
	~SimpleBmp();

	void Draw(CWnd*  pWnd, Image* pImage);
	void Draw(CDC* pDC, int x, int y, int dstWidth, int dstHeight, BYTE* pViewImg, int width, int height, int bitCount);
	void SetHeaderInfo(int width, int height, int bitCount);
};
