
// cvCam2013Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "cvCam2013.h"
#include "cvCam2013Dlg.h"
#include "afxdialogex.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// 带 ϱ   Լ
BOOL m_bThreadFlag = FALSE;
UINT ThreadImageCaptureFunc(LPVOID param);
IplImage* m_Image = NULL;
CvCapture* m_Capture = NULL;


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CcvCam2013Dlg dialog



CcvCam2013Dlg::CcvCam2013Dlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CcvCam2013Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CcvCam2013Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_VIEW, m_View);
	//  DDX_Control(pDX, IDC_BIN_IMAGE, m_BinImage);
	DDX_Control(pDX, IDC_BIN_IMAGE, m_BinView);
}

BEGIN_MESSAGE_MAP(CcvCam2013Dlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CAM_START, &CcvCam2013Dlg::OnBnClickedCamStart)
	ON_BN_CLICKED(IDC_CAM_STOP, &CcvCam2013Dlg::OnBnClickedCamStop)
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BMP_LOAD, &CcvCam2013Dlg::OnBnClickedLoadBmp)
	ON_BN_CLICKED(IDC_BMP_SAVE, &CcvCam2013Dlg::OnBnClickedSaveBmp)
END_MESSAGE_MAP()


// CcvCam2013Dlg message handlers

BOOL CcvCam2013Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	
	// ī޶ 
	//m_Capture = cvCaptureFromCAM(0);
	m_Capture = cvCreateCameraCapture(0);
	if (!m_Capture)  AfxMessageBox(_T("There is no camera captured!"));

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CcvCam2013Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CcvCam2013Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();

		if (m_Image != NULL) {

			// ---------------------------------------------------------------
			// ī޶󿡼 о  ȭ鿡 ׸
			// ---------------------------------------------------------------
			CRect rect;
			CDC* pDC;
			pDC = m_View.GetDC();
			m_View.GetClientRect(rect);

			m_cImage.CopyOf(m_Image);
			m_cImage.DrawToHDC(pDC->m_hDC, rect);

			ReleaseDC(pDC);


			// ---------------------------------------------------------------
			//  ҽ   ͸ ٷ  .
			//  imageData  ٷ ȯ   Ѵ. (unsigned char) 
			// ---------------------------------------------------------------

			// Į󿵻 ȭ Ѵ.
			pDC = m_BinView.GetDC();
			m_BinView.GetClientRect(rect);


			for (int y = 0; y < m_Image->height; y++) {
				for (int x = 0; x < m_Image->widthStep; x++) {
					if ( (unsigned char) m_Image->imageData[y*m_Image->widthStep + x] > 100)
						m_Image->imageData[y*m_Image->widthStep + x] = 255;
					else
						m_Image->imageData[y*m_Image->widthStep + x] = 0;
				}
			}
			// ---------------------------------------------------------------

			m_cImage.CopyOf(m_Image);
			m_cImage.DrawToHDC(pDC->m_hDC, rect);

			ReleaseDC(pDC);
		}
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CcvCam2013Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CcvCam2013Dlg::OnBnClickedCamStart()
{
	// TODO: Add your control notification handler code here

	m_bThreadFlag = TRUE;
	CWinThread *pThread = ::AfxBeginThread(ThreadImageCaptureFunc, this);

	//SetTimer(1, 30, NULL);
}


void CcvCam2013Dlg::OnBnClickedCamStop()
{
	// TODO: Add your control notification handler code here

	m_bThreadFlag = FALSE;

	//KillTimer(1);
}


void CcvCam2013Dlg::OnDestroy()
{
	CDialogEx::OnDestroy();

	// TODO: Add your message handler code here

	//KillTimer(1);

	if (m_Capture) cvReleaseCapture(&m_Capture);
}


UINT ThreadImageCaptureFunc(LPVOID param)
{
	CcvCam2013Dlg *pDlg = (CcvCam2013Dlg *)param;
	while (m_bThreadFlag)
	{
		//  ȹ
		m_Image = cvQueryFrame(m_Capture);
		pDlg->Invalidate(FALSE);

	}

	return 0;
}



void CcvCam2013Dlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default

	//  ȹ
	/*
	m_Image = cvQueryFrame(m_Capture);

	Invalidate(FALSE);
	*/

	CDialogEx::OnTimer(nIDEvent);
}


void CcvCam2013Dlg::OnBnClickedLoadBmp()
{
	// TODO: Add your control notification handler code here

	wchar_t szFilter[] = _T("Image (*.BMP) | *.BMP;*.GIF;*.JPG | All Files(*.*)|*.*||");
	CFileDialog dlg(TRUE, _T("bmp"), _T("test"), OFN_HIDEREADONLY, szFilter);
	if (dlg.DoModal() == IDOK)
	{
		CStringA filename(dlg.GetPathName().GetBuffer(0));
		m_Image = cvLoadImage(filename,1); // 1 for color
		Invalidate(FALSE);
	}
}


void CcvCam2013Dlg::OnBnClickedSaveBmp()
{
	// TODO: Add your control notification handler code here

	wchar_t szFilter[] = _T("Image (*.BMP) | *.BMP;*.GIF;*.JPG | All Files(*.*)|*.*||");
	CFileDialog dlg(FALSE, _T("bmp"), _T("test"), OFN_HIDEREADONLY, szFilter);
	if (dlg.DoModal() == IDOK)
	{
		cvFlip(m_Image, m_Image, 0); // vertical
		CStringA filename(dlg.GetPathName().GetBuffer(0));
		cvSaveImage(filename, m_Image);
	}

}
