﻿
// ocvCamDlg.h: 헤더 파일
//

#pragma once

#include "opencv2/opencv.hpp"
using namespace cv;

// CocvCamDlg 대화 상자
class CocvCamDlg : public CDialogEx
{
// 생성입니다.
public:
	CocvCamDlg(CWnd* pParent = nullptr);	// 표준 생성자입니다.

// 대화 상자 데이터입니다.
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_OCVCAM_DIALOG };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV 지원입니다.

public:
	Mat m_Image;
	VideoCapture m_Capture;
	BOOL m_bThreadFlag = FALSE;

	void FillBitmapInfo(BITMAPINFO* bmi, int width, int height, int bpp, int origin);
	void DisplayImage(CDC* pDC, CRect rect, Mat& srcimg);

// 구현입니다.
protected:
	HICON m_hIcon;

	// 생성된 메시지 맵 함수
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	CStatic m_View;
	afx_msg void OnBnClickedCamStart();
	afx_msg void OnBnClickedCamStop();
	afx_msg void OnBnClickedImgLoad();
	afx_msg void OnBnClickedImgSave();
};
