<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<!DOCTYPE HTML>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Highcharts Example</title>
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js"></script>
<style type="text/css">

${demo.css}
		</style>
		<script type="text/javascript">
		$(function () {
		    $('#container').highcharts({
		        chart: {
		            type: 'areaspline'
		        },
		        title: {
		            text: 'Average fruit consumption during one week'
		        },
		        legend: {
		            layout: 'vertical',
		            align: 'left',
		            verticalAlign: 'top',
		            x: 150,
		            y: 100,
		            floating: true,
		            borderWidth: 1,
		            backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'
		        },
		        xAxis: {
		            categories: [
		                'Monday',
		                'Tuesday',
		                'Wednesday',
		                'Thursday',
		                'Friday',
		                'Saturday',
		                'Sunday'
		            ],
		            plotBands: [{ // visualize the weekend
		                from: 4.5,
		                to: 6.5,
		                color: 'rgba(68, 170, 213, .2)'
		            }]
		        },
		        yAxis: {
		            title: {
		                text: 'Fruit units'
		            }
		        },
		        tooltip: {
		            shared: true,
		            valueSuffix: ' units'
		        },
		        credits: {
		            enabled: false
		        },
		        plotOptions: {
		            areaspline: {
		                fillOpacity: 0.5
		            }
		        },
		        series: [{
		            name: 'John',
		            data: [3, 4, 3, 5, 4, 10, 12]
		        }, {
		            name: 'Jane',
		            data: [1, 3, 4, 3, 3, 5, 4]
		        }]
		    });
		});



		</script>
	</head>
	<body>
<script src="js/highcharts.js"></script>
<script src="js/exporting.js"></script>

<div id="container"  style="max-width:30%; height: 35%"></div>


	</body>
</html>
